// From GLSL sandbox. changed a few things and made it tileable by David Hoskins.
// Water turbulence effect by joltz0r 2013-07-04, improved 2013-07-07
// License: Public Domain

#define TAU 6.28318530718
#define MAX_ITER 5


uniform float u_Elapsed;		// This is the time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;		// This is the dimensions of the viewport.

const float Pi = 3.14159;

void main( void )
{    
// gl_FragCoord.xy
// u_WindowSize.xy;
// u_Elapsed
// gl_FragColor
    
    float time = u_Elapsed * .2+23.0;
    // uv should be the 0-1 uv of texture...
    vec2 uv = gl_FragCoord.xy / u_WindowSize.xy;
    

    vec2 p = mod(uv*TAU, TAU)-250.0;

    vec2 i = vec2(p);
    float c = 1.0;
    float inten = .005;
    
    for (int n = 0; n < MAX_ITER; n++)
    {
        float t = time * (1.0 - (3.5 / float(n+1)));
        i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
        c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
    }
    c /= float(MAX_ITER);
    c = 1.17-pow(c, 1.4);
    vec3 colour = vec3(pow(abs(c), 8.0));
    colour = clamp(colour + vec3(0.0, 0.35, 0.5), 0.0, 1.0);
    
    

    gl_FragColor = vec4(colour, 1.0);
  

}